local main_loop = loadfile("squirrelscripts/main_ai_loop.nut");
dofile("squirrelscripts/ai_functions.nut");

function init() {
	attacked_scientists <- false;
	timer <- 660;
	
	foreach(squad in my_squads) {
		type = squad.get_type();
		if (type == 2 || type == 3)
			squad.select();
	}
	local moon_pos = side_3_squads[0].get_pos();
	order_move(moon_pos[0], moon_pos[1]);
}

function run_ai() {
	if (side_2_squads.len() < 2)
		return;

	check_for_launch_defence();
	if (world_frame_counter() <= timer)
		return;
		
	if (!attacked_scientists) {
		local fighter_counter = 0;
		local bomber_counter = 0;
		
		foreach(squad in my_squads) {
			if (fighter_counter < 2 && squad.get_type() == 0) {
				squad.highlight();
				++fighter_counter;
			}
			
			if (bomber_counter < 2 && squad.get_type() == 1) {
				squad.highlight();
				++bomber_counter;
			}
			
			if (fighter_counter == 2 && bomber_counter == 2)
				break;
		}
		
		local pos = side_1_squads[0].get_pos();
		add_waypoint(pos[0], pos[1]);
		launch_mission("attack");
		
		attacked_scientists = true;
		timer += 1200;
		return;
	}
	
	local my_big_ship = my_squads[0];
	foreach(squad in my_squads) {
		type = squad.get_type()
		if (type == 2 || type == 3) {
			my_big_ship = squad;
			break;
		}
	}
	
	//12000 as everyone is moving towards each other
	if (side_2_squads[0].get_distance(my_big_ship) >= 12000)
		return;
		
	local engineer_pos = side_2_squads[0].get_pos();
	launch_attack_wave(engineer_pos, 1);
	//1 minute
	timer = world_frame_counter() + 1800;
}

main_loop();
